#include <stdlib.h>

long mid (long x, long y)
{
    return x + (y-x)/2;
}

long Max (long x, long y)
{
    if (x>=y)
        return x;
    else
        return y;
}

long conST (long* A, long* st, long l, long r, long c)
{
    if (l==r)
    st[c] = A[l];
    else
    {
        long m = mid (l, r);
        long m1 = conST (A, st, l, m, 2*c+1);
        long m2 = conST (A, st, m+1, r, 2*c+2);
        st[c] = Max (m1, m2);
    }

    return st[c];
}

long findMax (long* st, long ql, long qr, long l, long r, long c)
{
    if (r<l || qr<l || ql>r)
        return -1;
    else if (ql<=l && r<=qr)
        return st[c];
    else
    {
        long m = mid (l, r);
        long m1 = findMax (st, ql, qr, l, m, 2*c+1);
        long m2 = findMax (st, ql, qr, m+1, r, 2*c+2);
        return Max (m1, m2);
    }
}

void updtST (long* st, long ul, long ur, long val, long l, long r, long c)
{
    if (ur<l || ul>r)
        return;
    if (l==r)
        st[c] = Max (st[c], val);
    else
    {
        st[c] = Max (st[c], val);
        long m = mid (l, r);
        updtST (st, ul, ur, val, l, m, 2*c+1);
        updtST (st, ul, ur, val, m+1, r, 2*c+2);
    }
    return;
}

int Slamke(int N, int* A, int M, int* T, int* X, int* Y)
{
    bool ST1 = true;
    for (long i=1; i<M; i++)
        if (T[i+1]<T[i])
        {
            ST1 = false;
            break;
        }

    if (ST1)
    {
        long p;
        for (long i=1; i<=N; i++)
            if (A[i]==1)
            {
                p = i;
                break;
            }

        long l = p, r = p;
        long cnt[N+1];
        for (long i=1; i<=N; i++)
            cnt[i] = 0;
        for (long i=1; i<=M; i++)
            if (T[i]==1)
            {
                if (X[i]<l && Y[i]>=l)
                    l = X[i];
                if (X[i]<=r && Y[i]>r)
                    r = Y[i];
            }
            else
                if (l<=X[i] && X[i]<=r)
                    cnt[X[i]]++;

        long res = 0;
        for (long i=1; i<N; i++)
            if (cnt[i]>res)
                res = cnt[i];

        return res;
    }
    else if (M<=10000)
    {
        long x = 2;
        while (x<N) x *= 2;
        x = 2*x - 1;
        long* st = (long*) malloc (x*sizeof (long));

        long* dp = (long*) malloc (N*sizeof (long));
        for (long i=1; i<=N; i++)
            if (A[i]==1)
                dp[i-1] = 0;
            else
                dp[i-1] = -1;

        conST (dp, st, 0, N-1, 0);

        for (long i=1; i<=M; i++)
            if (T[i]==1)
            {
                long newMax = findMax (st, X[i]-1, Y[i]-1, 0, N-1, 0);
                updtST (st, X[i]-1, Y[i]-1, newMax, 0, N-1, 0);

                for (long j=X[i]; j<=Y[i]; j++)
                    dp[j-1] = newMax;
            }
            else if (dp[X[i]-1] > -1)
            {
                dp[X[i]-1]++;
                updtST (st, X[i]-1, X[i]-1, dp[X[i]-1], 0, N-1, 0);
            }

        return findMax (st, 0, N-1, 0, N-1, 0);
    }
    else
    {
        long dp[N+1];

        for (long i=1; i<=N; i++)
            if (A[i]==1)
                dp[i] = 0;
            else
                dp[i] = -1;

        for (long i=1; i<=M; i++)
        {
            if (T[i]==1)
            {
                long newXY = Max (dp[X[i]], dp[Y[i]]);
                dp[X[i]] = newXY;
                dp[Y[i]] = newXY;
            }
            else if (dp[X[i]] > -1)
                dp[X[i]]++;
        }

        long res = 0;
        for (long i=1; i<=N; i++)
            if (dp[i]>res)
                res = dp[i];
        return res;
    }

    return 0;
}